@extends('layouts.admin')
@section('title', 'Edit Subject')
@section('content')
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-4">
        <div class="row mt-lg-4 mt-md-0 mt-0">
            <div class="col-md-12">
                <form id="UpdateFeedbackOption" class="add-user-form" action="{{ route('admin.subject.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="id" value="{{ base64_encode($editsubject->id) }}">

                      <div class="col-md-12 text-center">
                            <p class="profile-icons position-relative d-inline-block">
                                <a href="#" class="text-decoration-none" onclick="event.preventDefault(); document.getElementById('imageInput').click();">
                                    <!-- Show existing image or fallback -->
                                    {{-- <i class="fa-solid fa-circle-user fa-5x"></i> --}}
                                  <img src="{{ $editsubject->icon ? asset('storage/subjects/' . $editsubject->icon) : asset('img/no-image.png') }}"
                                    onerror="this.onerror=null; this.src='{{ asset('img/no-image.png') }}';"
                                    alt="User Image"
                                    id="profilePreview"
                                    style="width: 120px; height: 120px; object-fit: cover; border-radius: 50%;">
                                    <!-- Camera icon overlay -->
                                    <span class="camera-icons rounded-circle d-flex justify-content-center align-items-center position-absolute"
                                        style="width: 40px; height: 40px; bottom: 0; right: 0;">
                                        <i class="fa-solid fa-camera"></i>
                                    </span>
                                </a>

                                <!-- Hidden file input -->
                                <input type="file" name="icon" id="imageInput" class="d-none" accept="image/*" onchange="previewProfileImage(this);">
                            </p>
                             <!-- <p class="text-danger error_container" id="error-image"></p> -->
                        </div>
                        
                    <div class="row mt-4">
                        
                        <div class="col-md-6">
                            <label for="#" class="form-label">Name<span class="text-danger">*</span></label>
                            <input type="text" class="form-control rounded-2" id="f-name" value="{{ $editsubject->name }}"name="name">    
                           <p class="text-danger" id="error-name"></p>
                        </div>
 
                        <div class="col-md-6">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control rounded-2 form-select" name="status" id="status">
                                <option value="1" {{ $editsubject->status == 1 ? 'selected' : '' }}>Active</option>
                                <option value="0" {{ $editsubject->status == 0 ? 'selected' : '' }}>Inactive</option>
                            </select>
                        </div>
                   
                    </div>
                   
                    <div class="row mt-5">
                        <div class="col-md-6">
                        <button type="submit" id="updateBtn" class="btn add-btn px-4 py-3 w-100 rounded-pill">Update</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).on('submit', 'form#UpdateFeedbackOption', function(e) {
        e.preventDefault();

        var form = $(this);
        var formData = new FormData(this);
        var submitButton = $('#updateBtn');
        submitButton.prop('disabled', true).text('Updating...');

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message || "Updated Successfully");

                    window.setTimeout(function() {
                        window.location.href = "{{ route('admin.subjects') }}";
                    }, 2000);
                } else if (response.errors) {

                    $.each(response.errors, function(key, error) {
                        var errorId = `#error-${key.replace('.', '_')}`;
                        $(errorId).html(error[0]);
                    });
                } else {
                    alert("No changes were made.");
                }
            },
            error: function(xhr) {
                alert("An error occurred. Please try again.");
                console.log(xhr.responseText);
            }
        });
    });
</script>

<script>
    function previewProfileImage(input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = e => document.getElementById('profilePreview').src = e.target.result;
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
@endsection