@extends('layouts.admin')
@section('title', 'Subject Management')
@section('content')
@php
    $authCheck = auth()->check();
    $permission= auth()->user();
 @endphp
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-4">
        <div class="row align-items-start">

            <div class="col-md-12 add-div-btn">
                <div class="row justify-content-between">
                 {{-- @if($authCheck && $permission->hasPermission('subject-create')) --}}
                <div class="col-md-2 col-6">
                    <a href="{{ route('admin.subject.create') }}" class="btn add-btn px-4 py-2">Add Subject</a>
                </div>
                 {{-- @endif --}}
                    <div class="col-md-3 col-6">
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-magnifying-glass"></i></a></span>
                                <input type="text" class="form-control border-start-0" placeholder="Search User" id="searchData">
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            {{-- <div class="col-md-6">
                <div class="d-flex gap-3">
               
                    <div>
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-magnifying-glass"></i></a></span>
                                <input type="text" class="form-control border-start-0" placeholder="Search User">
                            </div>
                        </form>
                    </div>
                </div>
            </div> --}}
            {{-- <div class="col-md-6">
                <div class="d-flex justify-content-between mt-lg-0 mt-md-0 mt-4">
                    <form class="row align-items-center w-100">
                        <div class="col-md-6 col-6">
                            <div class="input-group h-auto">
                                <input type="text" class="form-control border-end-0" placeholder="Sort">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-arrow-up"></i></a><a href="#" class="text-dark"><i class="fa-solid fa-arrow-down"></i></a></span>
                            </div>
                        </div>
                        <div class="col-md-5 col-5">
                            <select class="form-control form-select" name="" id="">
                                <option value="filter">Filter</option>
                                <option value="value1">Value 1</option>
                            </select>
                        </div>
                        <div class="col-md-1 col-1">
                            <a href="#" class="text-dark"><i class="fa-solid fa-arrows-spin"></i></a>
                        </div>
                    </form>
                </div>
            </div> --}}
        </div>  
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="table-responsive user-table student-table" id="data-list">
                    @include('admin.subjects.ajax')
                    <!-- Loading Spinner -->
                    <div id="loading" class="position-absolute top-50 start-50" style="display:none;">
                        <div class="loader"></div>
                    </div>
                    
                </div>
               
            </div>
        </div>
    </div>  
</div>




<script>
    $(document).on('click', '.delete-btn', function () {
        var itemId = $(this).data('id');

        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ route('admin.subject.delete') }}",
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        id: itemId
                    },
                    success: function (response) {
                        Swal.fire(
                            'Deleted!',
                            'The Subject has been deleted.',
                            'success'
                        ).then(() => {
                            location.reload();
                        });
                    },
                    error: function (xhr) {
                        Swal.fire(
                            'Error!',
                            'Something went wrong.',
                            'error'
                        );
                    }
                });
            }
        });
    });
</script>

<script>
    $(document).ready(function() {

        function fetchData(url){
            let search = $('#searchData').val();

            $.ajax({
                url: url,
                type: "GET",
                data: { search: search },
                beforeSend: function() {
                    $('#loading').show();
                },
                success: function(data){
                    $('#data-list').html(data);
                    $('#loading').hide();
                },
                error: function() {
                    alert('Error loading data.');
                    $('#loading').hide();
                }
            });
        }

        // Handle Pagination Click
        $(document).on('click', '.pagination-wrapper a', function(e) {
            e.preventDefault();
            let url = $(this).attr('href');
            fetchData(url);
        });

        // Handle Search Input Typing (with delay)
        let typingTimer;
        let doneTypingInterval = 500; // 0.5 second after user stops typing

        $('#searchData').on('keyup', function () {
            clearTimeout(typingTimer);
            typingTimer = setTimeout(function() {
                //fetchData("{{ route('admin.revenue.index') }}");
                fetchData(window.location.href);
            }, doneTypingInterval);
        });

        $('#searchData').on('keydown', function () {
            clearTimeout(typingTimer);
        });

    });
</script>
@endsection
