@extends('layouts.admin')

@section('content')
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-1 mt-1">
        <div class="row mt-lg-4 mt-md-0 mt-0">
            <div class="col-md-12">
                <h1>Terms & Conditions</h1>
                <p class="mt-4">Version 1.0 – Effective Date: 1 June 2025</p>
                <p>Welcome to QuikWise ("Company", "we", "our", or "us"). These Terms and Conditions ("Terms") govern your access to and use of our website, applications, and services (together referred to as the "Platform").</p>
                <p>By registering, browsing, or using any part of our Platform, you confirm that you have read, understood, and agreed to these Terms. If you do not agree, please stop using the Platform immediately.</p>
                <p>1. Company Information (Legal Notice / Impressumspflicht)</p>
                <ul>
                    <li class="py-2">Business Name: QuikWise</li>
                    <li class="py-2">Legal Form: ProConsilium e.U.</li>
                    <li class="py-2">Registered Office: Körösistrasse 6, 8010 Graz, Austria</li>
                    <li class="py-2">Company Register Number: 445535z</li>
                    <li class="py-2">Register Court: Landesgericht für ZRS Graz</li>
                    <li class="py-2">VAT ID: ATU70544137</li>
                    <li class="py-2">Contact Email: support@quikwise.com</li>
                    <li class="py-2">Phone Number: +43 650 555 44 33</li>
                    <li class="py-2">Website: <a href="www.quikwise.com">www.quikwise.com</a></li>
                </ul>
                <p>2. Definitions</p>
                <ul>
                    <li class="py-2">User: Anyone using the Platform, including individuals and organizations.</li>
                    <li class="py-2">Account: A registered user profile needed to access core services.</li>
                    <li class="py-2">Services: All tools and features provided through QuikWise, including AI tutoring, analytics, and educational content.</li>
                    <li class="py-2">Content: Materials shown on or submitted to the Platform, such as text, files, videos, audio, or AI-generated outputs.</li>
                </ul>
                <p>3. Who Can Use QuikWise</p>
                <p>You may use QuikWise if you have the legal capacity to enter into a binding contract and are not prohibited by law from using online services. There is no strict age limit, but if you are under 18, we recommend using QuikWise with a parent or guardian’s supervision.</p>
                <p>4. Creating and Managing Your Account</p>
                <p>To access most features, you must create an account. You agree to provide accurate and current information and to keep your login credentials secure. If you suspect unauthorized use of your account, notify us immediately. We may suspend or delete accounts that violate these Terms or show signs of abuse or fraud.</p>
                <p>5. What You Can and Cannot Do on the Platform</p>
                <p>We expect all users to use the Platform legally and respectfully. You must not attempt to hack, overload, or damage our systems; upload viruses or malicious code; harass or impersonate others; or use QuikWise for illegal activities under Austrian, EU, or your local laws. Any violations may lead to account termination and legal action.</p>
                <p>6. What We Offer – Service Overview</p>
                <p>QuikWise provides AI-powered tutoring tools, personalized learning support, lesson plans, and performance tracking. These tools are designed to assist learning, not replace formal education or professional instruction. We do not guarantee academic results.</p>
                <p>7. Subscription, Billing & Payment</p>
                <p>We offer a 7-day free trial to new users. Subscriptions can be monthly, yearly, or pay-per-use, and are billed in advance via secure processors like Stripe or PayPal. Your subscription will auto-renew unless cancelled in advance.</p>
                <p>Refunds are not issued unless legally required. If prices change, you’ll be notified at least 14 days before the new rates apply.</p>
                <p>8. Intellectual Property</p>
                <p>All software, AI models, designs, and branding on the Platform are owned by QuikWise or its licensors. You may not copy, modify, resell, or redistribute any part of the Platform without written permission.</p>
                <p>9. User-Generated Content</p>
                <p>You retain ownership of any content you upload (e.g., notes, comments), but you grant us a royalty-free license to use it within the Platform. You may not upload illegal, harmful, or unauthorized content. We reserve the right to remove content that violates these Terms.</p>
                <p>10. Privacy & GDPR Compliance</p>
                <p>We process personal data in accordance with the General Data Protection Regulation (GDPR) and applicable privacy laws. We collect only what’s needed for service functionality and never sell your data.</p>
                <p>If you're in the EU or EEA, you may:</p>
                <ul>
                    <li class="py-2">Access, update, or delete your data</li>
                    <li class="py-2">Withdraw consent</li>
                    <li class="py-2">File a complaint with a data protection authority</li>
                </ul>
                <p>Read our full Privacy Policy or contact us at support@quikwise.com.</p>
                <p>11. Platform Availability and Updates</p>
                <p>We aim to provide stable access but cannot guarantee 24/7 availability. We may perform maintenance or updates at any time and reserve the right to change or remove features.</p>
                <p>12. Limitation of Liability</p>
                <p>QuikWise is not liable for any indirect or incidental damages, including data loss or academic consequences. We are not responsible for third-party services. Our maximum liability is limited to the amount you paid us in the last 12 months.</p>
                <p>13. Indemnification</p>
                <p>You agree to hold harmless QuikWise and its team from any claims or legal issues resulting from your use of the Platform, your content, or your violation of these Terms.</p>
                <p>14. Termination of Service</p>
                <p>We may suspend or terminate your account without notice if you violate these Terms or pose a legal or technical risk. Your right to use the Platform ends immediately. Some obligations (such as indemnity and liability limits) will still apply after termination.</p>
                <p>15. Updates to These Terms</p>
                <p>We may change these Terms occasionally. When we do, we’ll notify you by email, on the website, or within the app. Continued use after changes means you accept the updated version.</p>
                <p>16. Governing Law and Legal Jurisdiction</p>
                <p>These Terms are governed by Austrian law. Disputes will be resolved:</p>
                <ul>
                    <li>In Graz, Austria for B2B clients</li>
                    <li>Through the EU Online Dispute Resolution platform for consumers: <a href="https://ec.europa.eu/consumers/odr">https://ec.europa.eu/consumers/odr</a></li>
                </ul>
                <p>17. Severability</p>
                <p>If any part of these Terms is found unenforceable, the rest will remain valid and binding.</p>
                <p>18. Force Majeure</p>
                <p>We are not responsible for service disruptions due to events beyond our control, including natural disasters, wars, internet outages, or pandemics.</p>
                <p>19. Accessibility Statement</p>
                <p>We strive to make QuikWise accessible to all users, including those with disabilities. If you need help accessing our services, please contact us at support@quikwise.com.</p>
                <p>20. Language Versions</p>
                <p>These Terms are published in English. If they are translated into other languages, the English version will take legal precedence.</p>
                <p>21. Business Clients (B2B)</p>
                <p>For business users such as schools or organizations, we may offer custom agreements with tailored billing, onboarding, and service-level terms. Contact us for details.</p>
                <p>22. International Users (Non-EU)</p>
                <p>If you access QuikWise from outside the EU:</p>
                <ul>
                    <li>Austrian law applies, regardless of local law</li>
                    <li>We do not submit to foreign jurisdiction</li>
                    <li>Your data may be processed outside the EU under GDPR-compliant safeguards</li>
                    <li>You agree to resolve disputes in Austria</li>
                </ul>
                <p>23. Contact Information</p>
                <p class="mb-0">Email: support@quikwise.com</p>
                <p class="mb-0">Phone: +43 650 555 44 33</p>
                <p class="mb-0">Mailing Address: ProConsilium e.U., Körösistrasse 6, 8010 Graz, Austria</p>
                <p>Website: <a href="www.quikwise.com" class="">www.quikwise.com</a></p>
                <p>24. Responsible Use of AI</p>
                <p>QuikWise’s AI tools are intended to support learning and academic development. Users may not use AI-generated content to cheat, plagiarize, or bypass educational standards. You are also prohibited from reverse-engineering or extracting data from our AI models.</p>
                <p>25. Suggestions and Feedback</p>
                <p>We appreciate your feedback. If you suggest improvements, features, or ideas, you grant us the right to use them freely, without obligation or compensation. You do not retain ownership of features implemented based on your suggestions.</p>
                <p>26. Account Inactivity</p>
                <p>We reserve the right to deactivate accounts that remain inactive for 12 months or more. Before doing so, we will notify you and provide a chance to keep your account active. Inactive accounts may be permanently deleted along with associated data.</p>
                <p>27. Communication and Email Consent</p>
                <p>By using the Platform, you agree to receive service-related emails such as billing notifications, support responses, or security alerts. You may opt out of non-essential promotional emails at any time via the unsubscribe link.</p>
                <h5>Thank you for choosing QuikWise — we're here to support your learning journey every step of the way!</h5>
            </div>
        </div>
    </div>
</div>

@endsection