@extends('layouts.admin')
@section('title', 'Create User')
@section('content')
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
	<div class="row mt-lg-4 mt-md-0 mt-0">
	<div class="col-md-12">
	    <div class="px-4">
		<a href="{{ route('admin.users.index') }}" class="text-decoration-none text-dark"><i class="fa-solid fa-chevron-left me-2"></i>Add User</a>
	    </div>
	</div>
	</div>
        <div class="row mt-lg-4 mt-md-0 mt-0">
            <div class="col-md-12">
                {{-- @if(session('success'))
                    <div class="alert alert-success mt-3">{{ session('success') }}</div>
                @endif --}}
              
                <form id="userform" action="{{ route('admin.users.store') }}" method="POST" class="add-user-form p-4" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <p class="profile-icons position-relative d-inline-block">
                                <a href="#" class="text-decoration-none" onclick="event.preventDefault(); document.getElementById('imageInput').click();">
                                    <i class="fa-solid fa-circle-user fa-5x"></i>
                                    <span class="camera-icons rounded-circle d-flex justify-content-center align-items-center position-absolute bottom-0 end-0 shadow"
                                          style="width: 40px; height: 40px;">
                                        <i class="fa-solid fa-camera"></i>
                                    </span>
                                </a>
                    
                                <!-- Hidden file input -->
                                <input type="file" class="form-control d-none" name="image" id="imageInput" accept="image/*">
                            </p>
                            <p class="text-danger error_container" id="error-image"></p>

                        </div>
                    </div>
                    

                    <div class="row mt-4">
                        <div class="col-md-6">
                            <label for="#" class="form-label">Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control rounded-2" placeholder="Enter name" autocomplete="off" name="name" >    
                             <p class="text-danger error_container" id="error-name"></p>
                            {{-- @if($errors->has('name'))
                                <div class="error text-danger">{{ $errors->first('name') }}</div>
                            @endif --}}
                        </div>

                        <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                            <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                            <input type="email" class="form-control rounded-2" placeholder="Enter email" name="email" autocomplete="off" value="">
                             <p class="text-danger error_container" id="error-email"></p>

                            {{-- @if($errors->has('email'))
                                <div class="error text-danger">{{ $errors->first('email') }}</div>
                            @endif --}}
                        </div>
                    </div>
                    <div class="row mt-4">
                        {{-- <div class="col-md-6">
                            <label for="pwd" class="form-label">Password <span class="text-danger">*</span></label>
                            <input type="password" class="form-control rounded-2" id="pwd" placeholder="Enter password" name="password" required>
                            @if($errors->has('password'))
                                <div class="error text-danger">{{ $errors->first('password') }}</div>
                            @endif
                        </div> --}}

                        <div class="col-md-6">
                            <label for="pwd" class="form-label">Password <span class="text-danger">*</span></label>
                            <div class="position-relative">
                                <input type="password" class="form-control rounded-2 pe-5" id="pwd" placeholder="Enter password" autocomplete="off" name="password">
                                <span class="position-absolute top-50 end-0 translate-middle-y me-3" style="cursor: pointer;" onclick="togglePassword()">
                                    <i class="fa-solid fa-eye-slash" id="togglePwdIcon"></i>
                                </span>
                            </div>
                             <p class="text-danger error_container" id="error-password"></p>

                            {{-- @if($errors->has('password'))
                                <div class="error text-danger">{{ $errors->first('password') }}</div>
                            @endif --}}
                        </div>

                        <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                            <label for="role" class="form-label">Assign Role<span class="text-danger">*</span></label>
                            <select class="form-control rounded-2 form-select" name="role" id="role">
                                <option value="">Select role</option>
                                @foreach($roles as $role)
                                <option value="{{ $role->id }}">{{ $role->name }}</option>
                            @endforeach
                            </select>
                             <p class="text-danger error_container" id="error-role"></p>

                            {{-- @if($errors->has('role'))
                                <div class="error text-danger">{{ $errors->first('role') }}</div>
                            @endif --}}
                        </div>
                    </div>
                    <div class="row mt-5">
                        <div class="col-md-6">
                            <button type="submit" class="btn add-btn px-4 py-3 w-100 rounded-pill submit">Save</button>
                            {{-- <a href="{{ route('admin.users.index') }}" class="btn add-btn px-4 py-3 w-100 rounded-pill">
                                Create Admin
                            </a> --}}
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
      $(document).on('submit', 'form#userform', function(event) {
                        
        event.preventDefault();
        $('p.error_container').html("");

        var form = $(this);
        var formid = $(this).attr('id');

        var data = new FormData($(this)[0]);
        var url = form.attr("action");
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> loading...';
        $('.submit').attr('disabled', true);
        $('.form-control').attr('readonly', true);
        if ($('.submit').html() !== loadingText) {
            $('.submit').html(loadingText);
        }
        $.ajax({
            type: form.attr('method'),
            url: url,
            data: data,
            cache: false,
            contentType: false,
            processData: false,
            success: function(response) {
                // window.setTimeout(function() {
                    
                // }, 2000);
                //console.log(response);
                if (response.success == true) {
                    //notify
                    toastr.success("Created Successfully");

                    // redirect to google after 5 seconds
                    window.setTimeout(function() {
                        window.location = "{{ route('admin.users.index') }}";
                    }, 2000);
                }
                //show the form validates error
               
                if (response.success == false) {
                    for (control in response.errors) {
                        var error_text = control.replace('.', "_");
                        $('#'+formid+' #error-' + error_text).html(response.errors[control]);
                        
                    }

                    $('.submit').attr('disabled', false);
                    $('.form-control').attr('readonly', false);
                    $('.submit').html('Save');
                    // console.log(response.errors);
                }
            },
            error: function(response) {
                alert("Error: " + errorThrown);
                console.log(response);
                $('.submit').attr('disabled', false);
                    $('.form-control').attr('readonly', false);
                    $('.submit').html('Save');
            }
        });
        event.stopImmediatePropagation();
        return false;
    });
          
</script>


<script>
    function togglePassword() {
        const passwordInput = document.getElementById('pwd');
        const icon = document.getElementById('togglePwdIcon');
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        } else {
            passwordInput.type = 'password';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        }
    }
</script>



@endsection