@extends('layouts.admin')
@section('title', 'User Management')
@section('content')

 @php
    $authCheck = auth()->check();
    $permission= auth()->user();
 @endphp
 @if($authCheck && $permission->hasPermission('user-show'))
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row align-items-center">

            <div class="col-md-6 user-filterDiv">
                <div class="row align-items-center">
                    @if($authCheck && $permission->hasPermission('user-create'))
                        <div class="col-md-4 col-12 add-div-btn">
                            <a href="{{ route('admin.users.create') }}" class="btn add-btn px-6 py-2">Add Users</a>
                        </div>
                    @endif
                    {{-- <div class="col-md-10 col-12 add-div-btn">
                        <form method="GET" action="{{ route('admin.users.index') }}">
                            <div class="row align-items-center">
                                <div class="col-md-4 col-6 my-lg-0 my-md-0 my-3">
                                    <input type="text" name="name" class="form-control" placeholder="Search by name" value="{{ request('name') }}">
                                </div>
                                <div class="col-md-4 col-6 my-lg-0 my-md-0 my-3">
                                    <input type="text" name="email" class="form-control" placeholder="Search by email" value="{{ request('email') }}">
                                </div>
                                <div class="col-md-2 col-6">
                                    <button type="submit" class="btn add-btn w-100 py-2">Search</button>
                                </div>
                                <div class="col-md-2 col-6">
                                    <a href="{{ route('admin.users.index') }}" class="btn add-btn w-100 py-2">Cancel</a>
                                </div>
                            </div>
                        </form>
                    </div> --}}
                </div>
            </div>

            <div class="col-md-6">
                <div class="d-flex gap-3 justify-content-end">
                   
                    <div class="search-div">
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-magnifying-glass"></i></a></span>
                                <input type="text" class="form-control border-start-0" placeholder="Search User" id="searchData">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
          
            {{-- <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                <div class="d-flex justify-content-between">
                    <form class="row align-items-center w-100">
                        <div class="col-lg-6 col-md-6 col-6">
                            <div class="input-group">
                                <input type="text" class="form-control border-end-0" placeholder="Sort">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-arrow-up"></i></a><a href="#" class="text-dark"><i class="fa-solid fa-arrow-down"></i></a></span>
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-5 col-5">
                            <select class="form-control form-select" name="" id="">
                                <option value="filter">Filter</option>
                                <option value="value1">Value 1</option>
                            </select>
                        </div>
                        <div class="col-lg-1 col-md-1 col-1">
                            <a href="#" class="text-dark"><i class="fa-solid fa-arrows-spin"></i></a>
                        </div>
                    </form>
                </div>
            </div> --}}
        </div>  
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="table-responsive user-table student-table" id="data-list">
                    @include('admin.users.ajax')
                    <!-- Loading Spinner -->
                    <div id="loading" class="position-absolute top-50 start-50" style="display:none;">
                        <div class="loader"></div>
                    </div>
                   
                </div>
               
            </div>
        </div>
    </div>  
</div>
 @endif
<script>
      $(document).on('change', '.change-status', function () {
        const checkbox = $(this);
        const id = checkbox.data('id');
        const name = checkbox.data('name');
        const isChecked = checkbox.is(':checked');
        const type = isChecked ? btoa('enable') : btoa('disable');
        const action = isChecked ? 'activate' : 'deactivate';

        Swal.fire({
            icon: 'warning',
            title: `Are you sure you want to ${action} "${name}"?`,
            showCancelButton: true,
            confirmButtonColor: '#007358',
            confirmButtonText: 'YES',
            cancelButtonText: 'CANCEL'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: "{{ route('admin.users.status') }}",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        'id': id,
                        'type': type
                    },
                    success: function (response) {
                        if (response.success) {
                            $(`#statusLabel${atob(id)}`).text(isChecked ? 'Active' : 'Inactive');
                            toastr.success("Status Changed Successfully");
                        } else {
                            toastr.error("Failed to change status");
                            checkbox.prop('checked', !isChecked); // Revert switch
                        }
                    },
                    error: function (xhr, textStatus, errorThrown) {
                        toastr.error("An error occurred: " + errorThrown);
                        checkbox.prop('checked', !isChecked); // Revert switch
                    }
                });
            } else {
                checkbox.prop('checked', !isChecked); // Revert if cancelled
            }
        });
    });
</script>

<script>
    $(document).ready(function() {

        function fetchData(url){
            let search = $('#searchData').val();

            $.ajax({
                url: url,
                type: "GET",
                data: { search: search },
                beforeSend: function() {
                    $('#loading').show();
                },
                success: function(data){
                    $('#data-list').html(data);
                    $('#loading').hide();
                },
                error: function() {
                    alert('Error loading data.');
                    $('#loading').hide();
                }
            });
        }

        // Handle Pagination Click
        $(document).on('click', '.pagination-wrapper a', function(e) {
            e.preventDefault();
            let url = $(this).attr('href');
            fetchData(url);
        });

        // Handle Search Input Typing (with delay)
        let typingTimer;
        let doneTypingInterval = 500; // 0.5 second after user stops typing

        $('#searchData').on('keyup', function () {
            clearTimeout(typingTimer);
            typingTimer = setTimeout(function() {
                //fetchData("{{ route('admin.revenue.index') }}");
                fetchData(window.location.href);
            }, doneTypingInterval);
        });

        $('#searchData').on('keydown', function () {
            clearTimeout(typingTimer);
        });

    });
</script>

@endsection