<?php

use Illuminate\Http\Request;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\PlanController;
use App\Http\Controllers\API\ChatController;
use App\Http\Controllers\API\QuizControllers;
use App\Http\Controllers\API\CommonController;
use App\Http\Controllers\API\PasswordResetController;
use App\Http\Controllers\API\SubjectMasterController;
use App\Http\Controllers\API\StripeSubscriptionController;

// use Laravel\Cashier\Exceptions\IncompletePayment;
// use Stripe\Stripe; // Import Stripe

Route::post('/register', [AuthController::class, 'register']);
Route::post('/verifyOtp', [AuthController::class, 'verifyOtp']);
Route::post('/resendOtp', [AuthController::class, 'resendOtp']);
Route::post('/login', [AuthController::class, 'login']);
Route::post('/socialLogin', [AuthController::class, 'socialLogin']);
Route::post('/forgot-password', [PasswordResetController::class, 'sendOtp']);
Route::post('/verify-otp', [PasswordResetController::class, 'verifyOtp']);
Route::post('/resend-otp', [PasswordResetController::class, 'resendOtp']);
Route::post('/reset-password', [PasswordResetController::class, 'resetPassword']);
Route::get('/faqs', [CommonController::class, 'faq']);
Route::get('/plans', [PlanController::class, 'plans']);

// Protected Routes (Require Authentication)
// Route::middleware('auth:sanctum')->group(function () {
Route::middleware('auth.token')->group(function () {
    Route::get('/profile', [AuthController::class, 'profile']);
    Route::post('/profileUpdate', [AuthController::class, 'profileUpdate']);
    Route::post('/changePassword', [AuthController::class, 'changePassword']);

    Route::post('/createChatRoom', [ChatController::class, 'createRoom']);
    Route::get('/historyChatRoom', [ChatController::class, 'historyChatRoom']);
    Route::post('/renameChatRoom', [ChatController::class, 'renameChatRoom']);
    Route::post('/createChat', [ChatController::class, 'createChat']);
    Route::post('/historyChat', [ChatController::class, 'historyChat']);
    Route::post('/feedbackChat', [ChatController::class, 'feedbackChat']);

    Route::get('/my-plan', [PlanController::class, 'myPlan']);
    // Route::get('/plans', [PlanController::class, 'plans']);
    Route::get('/subjectList', [SubjectMasterController::class, 'index']);

    Route::get('/logout', [AuthController::class, 'logout']);
    Route::get('/deleteAccount', [AuthController::class, 'deleteAccount']);

    Route::post('/create-checkout-session', [StripeSubscriptionController::class, 'createCheckoutSession']);
    Route::post('/checkout-success', [StripeSubscriptionController::class, 'checkoutSuccess']);
    Route::post('/checkout-failed', [StripeSubscriptionController::class, 'checkoutFailed']);
    Route::get('/check-subscription', [StripeSubscriptionController::class, 'checkSubscription']);
    Route::get('/cancel-subscription', [StripeSubscriptionController::class, 'cancelSubscription']);
    Route::post('/change-plan', [StripeSubscriptionController::class, 'changePlan']);
    Route::post('/paymentHistory', [StripeSubscriptionController::class, 'paymentHistory']);

    Route::post('/contact', [CommonController::class, 'contact']);
    Route::post('/feedback', [CommonController::class, 'feedback']);
    Route::get('/feedback-option', [CommonController::class, 'feedbackoption']);
    Route::get('/sampleQuestion', [CommonController::class, 'sampleQuestion']);
    // Route::get('/faqs', [CommonController::class, 'faq']);
    Route::post('/togglePin', [CommonController::class, 'togglePin']);

    Route::get('/quiz-generate', [QuizControllers::class, 'generate']);
    Route::post('/quiz-submission', [QuizControllers::class, 'quizSubmit']);
    
    
});

Route::post('/stripe-webhook', [StripeSubscriptionController::class, 'handleWebhook']);

Route::get('/user', function (Request $request) {

    // $data = App\Models\PersonalAccessToken::where('token', hash('sha256', '2b8CsO3KZ0NbxCTTys3rDhcND4Wv5lYpOAUiCUXj'))->first();
    // return response()->json(['tdata'=>$data ]);
    echo \Str::uuid();
    return response()->json('$request->user()');
}); //->middleware('auth.token');
