<?php

use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\PermissionControllerNew;
use App\Http\Controllers\Admin\StudentController;
use App\Http\Controllers\Admin\BillingController;
use App\Http\Controllers\Admin\MyprofileController;
use App\Http\Controllers\Admin\FeedbackController;
use App\Http\Controllers\Admin\FaqcategoryController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\RevenueController;
use App\Http\Controllers\Admin\FeedbackOptionController;
use App\Http\Controllers\Admin\ContactController;
use App\Http\Controllers\Admin\SubjectController;
use App\Http\Controllers\Admin\HomeController;
use App\Http\Controllers\Admin\SampleQuestionController;
use Illuminate\Support\Facades\Session;
use Illuminate\Session\Middleware\StartSession;




use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/test-loc', function () {

    $user_ip = $_SERVER['REMOTE_ADDR'];
    echo $user_ip.'<br><br><pre>';
    $TOKEN = 'f52e6c5fb45336';

    $url = "https://ipinfo.io/$user_ip/json";
    $resp= file_get_contents($url);

    // $curl = curl_init($url);
    // curl_setopt($curl, CURLOPT_URL, $url);
    // curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

    // //for debug only!
    // curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
    // curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

    // $resp = curl_exec($curl);
    // curl_close($curl);
    var_dump(json_decode($resp));








    
    $data = file_get_contents("http://ip-api.com/php");
    $data = unserialize($data);
    echo '<pre>';
    var_dump($data);
});

Route::get('/term-and-condition', function () {
    return view('admin.term-condition/create');
});

Route::prefix('admin')->name('admin.')->group(function () {

    Route::get('/term-and-condition', function () {
        return view('admin.term-condition/create');
    });
    
    Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [AuthController::class, 'login'])->name('login.post');

    Route::middleware(['auth:admin'])->group(function () {
        Route::get('/dashboard', function () { return view('admin.dashboard'); })->name('dashboard');

        Route::get('dashboard',[HomeController::class,'dashboard'])->name('dashboard');
        //Direct Use Purpose
        // Route::get('permission/new', [PermissionControllerNew::class, 'create'])->name('permission.create.new');
        // Route::post('permission/new/insert', [PermissionControllerNew::class, 'store'])->name('permission.store.new');
       
        Route::resource('roles', RoleController::class);
        
        Route::resource('permissions', PermissionController::class);
        // Route::resource('permissions', PermissionController::class)->only(['create', 'store']);
        // Route::resource('permissions', PermissionController::class)->only(['edit', 'update'])->middleware('permission:edit permissions');
        // Route::resource('permissions', PermissionController::class)->only(['destroy'])->middleware('permission:delete permissions');
        Route::put('roles/{role}/permissions', [RoleController::class, 'updatePermissions'])->name('roles.updatePermissions');
        
        // Route::resource('users', UserController::class);

        Route::get('users', [UserController::class, 'index'])->name('users.index')->middleware(['permission:user-show']);
        Route::get('users/create', [UserController::class, 'create'])->name('users.create');
        Route::post('users', [UserController::class, 'store'])->name('users.store');
        Route::get('users/{id}', [UserController::class, 'edit'])->name('users.edit');
        Route::post('users-update', [UserController::class, 'update'])->name('users.update');
        Route::delete('users/{user}', [UserController::class, 'destroy'])->name('users.destroy');
        Route::post('users-status',[UserController::class,'userStatus'])->name('users.status');
        Route::get('users/{user}', [UserController::class, 'show'])->name('users.show');

         
        Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

        //Student Management
        Route::get('student', [StudentController::class, 'index'])->name('student');
        Route::get('student-edit/{id}', [StudentController::class, 'student_edit'])->name('student.edit');
        Route::post('student-update', [StudentController::class, 'student_update'])->name('student.update');
        Route::post('student-delete', [StudentController::class, 'student_delete'])->name('student.delete');
        Route::post('status',[StudentController::class,'studentStatus'])->name('status');
        Route::get('student-view/{id}', [StudentController::class, 'student_view'])->name('student.view');

        //Billing
        Route::get('billing', [BillingController::class, 'index'])->name('billing');
        Route::get('billing-edit/{id}', [BillingController::class, 'billing_edit'])->name('billing.edit');
        Route::post('billing-update', [BillingController::class, 'billing_update'])->name('billing.update');
        Route::post('billing-delete', [BillingController::class, 'billing_delete'])->name('billing.delete');
       
        //Profile
        Route::get('myprofile', [MyprofileController::class, 'index'])->name('myprofile');
        Route::post('myprofile-update', [MyprofileController::class, 'update_profile'])->name('myprofile.update');
        Route::post('change-password', [MyprofileController::class, 'changePassword'])->name('change.password');

        //Feedback
        Route::get('feedback', [FeedbackController::class, 'index'])->name('feedback');
        Route::get('feedback-view/{id}', [FeedbackController::class, 'feedback_view'])->name('feedback.view');

        //FAQ Category
        Route::get('faq-category', [FaqcategoryController::class, 'index'])->name('faq-category');
        Route::get('faq-category/create', [FaqcategoryController::class, 'faq_create'])->name('faq-category.create');
        Route::post('faqcategory/store',[FaqcategoryController::class,'faqcat_store'])->name('faqcategory.store');
        Route::get('faqcategory-edit/{id}', [FaqcategoryController::class, 'faqcat_edit'])->name('faqcategory.edit');
        Route::post('faqcategory-update', [FaqcategoryController::class, 'faqcat_update'])->name('faqcategory.update');
        Route::post('faqcatstatus',[FaqcategoryController::class,'faqcatStatus'])->name('faqcatstatus');
        Route::post('faqcat-delete', [FaqcategoryController::class, 'faqcat_delete'])->name('faqcat.delete');

        //FAQ
        Route::get('/faqs', [FaqController::class, 'index'])->name('faqs.index');
        Route::get('/faqs/create', [FaqController::class, 'create'])->name('faqs.create');
        Route::post('/faqs-post', [FaqController::class, 'store'])->name('faqs.store');
        Route::get('faqs-edit/{id}', [FaqController::class, 'edit'])->name('faqs.edit');
        Route::put('faqs-update', [FaqController::class, 'update'])->name('faqs.update');
        Route::post('/faq/status',[FaqController::class,'faqStatus'])->name('faq.status');
        Route::post('/faqs', [FaqController::class, 'destroy'])->name('faqs.destroy');

        //FeedBackOption
        Route::get('feedback-option', [FeedbackOptionController::class, 'index'])->name('feedback-option');
        Route::get('feedback-option/create', [FeedbackOptionController::class, 'feedbackoption_create'])->name('feedback-option.create');
        Route::post('feedback-option/store',[FeedbackOptionController::class,'feedbackoption_store'])->name('feedbackoption.store');
        Route::get('feedbackoption-edit/{id}', [FeedbackOptionController::class, 'feedbackoption_edit'])->name('feedbackoption.edit');
        Route::post('feedbackoption-update', [FeedbackOptionController::class, 'feedbackoption_update'])->name('feedbackoption.update');
        Route::post('feedbackoption-status',[FeedbackOptionController::class,'feedbackoptionStatus'])->name('feedbackoption-status');
        Route::post('feedbackoption-delete', [FeedbackOptionController::class, 'feedbackoption_delete'])->name('feedbackoption.delete');

        //Contact
        Route::get('contacts', [ContactController::class, 'index'])->name('contacts');
        Route::get('contact/{id}', [ContactController::class, 'contact_view'])->name('contact.view');


       //Subjects
        Route::get('subjects', [SubjectController::class, 'index'])->name('subjects');
        Route::get('subject/create', [SubjectController::class, 'subject_create'])->name('subject.create');
        Route::post('subject/store',[SubjectController::class,'subject_store'])->name('subject.store');
        Route::get('subject/{id}', [SubjectController::class, 'subject_edit'])->name('subject.edit');
        Route::post('subject-update', [SubjectController::class, 'subject_update'])->name('subject.update');
        // Route::post('subject-status',[SubjectController::class,'subjectStatus'])->name('subject-status');
        Route::post('subject-delete', [SubjectController::class, 'subject_delete'])->name('subject.delete');

        //SampleQuestion

        Route::get('sample-questions',[SampleQuestionController::class,'index'])->name('sample-questions');
        Route::post('/sample-questions-store',[SampleQuestionController::class,'store'])->name('samplequestions-store');
        Route::get('sample-questions/edit/{id}',[SampleQuestionController::class,'samplequestions_edit']);
        Route::post('sample-questions-update',[SampleQuestionController::class,'samplequestions_update'])->name('samplequestions-update');
        Route::post('sample-questions-delete',[SampleQuestionController::class,'samplequestions_delete'])->name('samplequestions-delete');
        

        //Revenue
        Route::get('/revenue', [RevenueController::class, 'index'])->name('revenue.index');
      
    });

   
});

require __DIR__.'/auth.php';
