
<?php $__env->startSection('title', 'Edit User'); ?>
<?php $__env->startSection('content'); ?>
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-4">
        <div class="row align-items-center">
            <div class="col-md-12">
                <p><a href="<?php echo e(route('admin.users.index')); ?>" class="text-dark text-decoration-none position-relative"><i class="fa-solid fa-chevron-left me-2"></i> Edit User</a></p>
            </div>
        </div>  
        <div class="row mt-4">
            <div class="col-md-12">
                <form class="add-user-form" id="Updateuser" action="<?php echo e(route('admin.users.update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" value="<?php echo e(base64_encode($editadmin->id)); ?>">
                    <div class="row">
                       
                        <div class="col-md-12 text-center">
                            <p class="profile-icons position-relative d-inline-block">
                                <a href="#" class="text-decoration-none" onclick="event.preventDefault(); document.getElementById('imageInput').click();">
                                    <!-- Show existing image or fallback -->
                                    
                                  <img src="<?php echo e($editadmin->image ? asset('storage/user/' . $editadmin->image) : asset('img/no-image.png')); ?>"
                                    onerror="this.onerror=null; this.src='<?php echo e(asset('img/no-image.png')); ?>';"
                                    alt="User Image"
                                    id="profilePreview"
                                    style="width: 120px; height: 120px; object-fit: cover; border-radius: 50%;">
                                    <!-- Camera icon overlay -->
                                    <span class="camera-icons rounded-circle d-flex justify-content-center align-items-center position-absolute"
                                        style="width: 40px; height: 40px; bottom: 0; right: 0;">
                                        <i class="fa-solid fa-camera"></i>
                                    </span>
                                </a>

                                <!-- Hidden file input -->
                                <input type="file" name="image" id="imageInput" class="d-none" accept="image/*" onchange="previewProfileImage(this);">
                            </p>
                             <p class="text-danger error_container" id="error-image"></p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <label for="#" class="form-label">Full Name<span class="text-danger">*</span></label>
                            <input type="text" class="form-control rounded-2" value="<?php echo e($editadmin->name); ?>" id="f-name" placeholder="Enter Name" name="name">    
                             <p class="text-danger error_container" id="error-name"></p>
                        </div>
                        <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                            <label for="email" class="form-label">Email address<span class="text-danger">*</span></label>
                            <input type="email" class="form-control rounded-2" value="<?php echo e($editadmin->email); ?>" id="email" placeholder="Enter email" name="email">
                            <p class="text-danger error_container" id="error-email"></p>
                        </div>
                    </div>
                    <div class="row mt-4">

                        <div class="col-md-6">
                            <label for="role" class="form-label">Select Role</label>
                            <select class="form-control rounded-2 form-select" name="role" id="role">
                                <option value="" disabled>Select Role</option>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($role->id); ?>" <?php echo e($editadmin->role_id == $role->id ? 'selected' : ''); ?>><?php echo e($role->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <!-- Add more roles as needed -->
                            </select>
                             <p class="text-danger error_container" id="error-role"></p>
                        </div>

                        <div class="col-md-6">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control rounded-2 form-select" name="status" id="status">
                                <option value="1" <?php echo e($editadmin->status == 1 ? 'selected' : ''); ?>>Active</option>
                                <option value="0" <?php echo e($editadmin->status == 0 ? 'selected' : ''); ?>>Inactive</option>
                            </select>
                        </div>

                    </div>
                    <div class="row mt-5">
                        <div class="col-md-6">
                            <button type="submit" class="btn add-btn px-4 py-3 w-100 rounded-pill">Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).on('submit', 'form#Updateuser', function(e) {
        e.preventDefault();

        var form = $(this);
        var formData = new FormData(this);

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
               
                if (response.success) {
                    toastr.success(response.message || "Updated Successfully");

                    window.setTimeout(function() {
                        window.location.href = "<?php echo e(route('admin.users.index')); ?>";
                    }, 2000);
                } else if (response.errors) {

                    $.each(response.errors, function(key, error) {
                        var errorId = `#error-${key.replace('.', '_')}`;
                        $(errorId).html(error[0]);
                    });
                } else {
                    alert("No changes were made.");
                }
            },
            error: function(xhr) {
                alert("An error occurred. Please try again.");
                console.log(xhr.responseText);
            }
        });
    });
</script>

<script>
    function previewProfileImage(input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = e => document.getElementById('profilePreview').src = e.target.result;
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/quikwise-admin/resources/views/admin/users/edit.blade.php ENDPATH**/ ?>