<?php $__env->startSection('title', 'Billing Management'); ?>
<?php $__env->startSection('content'); ?>
  <?php
    $authCheck = auth()->check();
    $permission= auth()->user();
?>

<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row align-items-center">

            
        </div>  
        <div class="row mt-4">
            <div class="col-md-12">
                
                <div class="table-responsive user-table student-table">
                    <table class="table table-striped">
                        <thead class="border-bottom">
                            <tr>
                                <th>S.No.</th>
                                <th>Plan Name</th>
                                <th>Billing Period</th>
                                <th>Amount</th>
                                <th>Features</th> 
                                <th>Actions</th> 
                            </tr>
                        </thead>
                       
                        <tbody>
                            <?php $__currentLoopData = $billings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $billing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                            <?php
                                $points = json_decode($billing->points);
                            ?>

                                <td><?php echo e($key + 1); ?></td>
                                <td><?php echo e($billing->name); ?></td>
                                <td><?php echo e($billing->interval); ?></td>
                                <td><?php echo e($billing->price); ?></td>
                                <td>
                                   
                                    <?php if(is_array($points)): ?>
                                        <ul class="mb-0">
                                            <?php $__currentLoopData = $points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                               <li>
                                                    <?php echo e(\Illuminate\Support\Str::limit($point->text,100)); ?> <?php echo e($point->mark == 1 ? '' : ''); ?>

                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php else: ?>
                                        <?php echo e($billing->points); ?>

                                    <?php endif; ?>
                                </td>

                                <td class="">
                                     <?php if($authCheck && $permission->hasPermission('billing-edit')): ?>
                                    <a href="<?php echo e(route('admin.billing.edit', base64_encode($billing->id))); ?>" class="text-success text-decoration-none me-2" data-bs-toggle="tooltip" data-bs-placement="top" title="Edit">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a> 
                                    <?php endif; ?>

                                    <!-- <?php if($authCheck && $permission->hasPermission('billing-delete')): ?>
                                    <a href="javascript:void(0);" 
                                        class="text-danger me-2 delete-btn text-decoration-none" 
                                        data-bs-toggle="tooltip" data-bs-placement="top" title="Delete"
                                        data-id="<?php echo e(base64_encode($billing->id)); ?>">
                                            <i class="fa-solid fa-trash"></i>
                                    </a>
                                    <?php endif; ?> -->
                                </td>
                            </tr>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          
                        </tbody>
                    </table>
                </div>
             
            </div>
        </div>
    </div>  
</div>

<script>
$(document).on('click', '.delete-btn', function () {
    var itemId = $(this).data('id');

    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: "<?php echo e(route('admin.billing.delete')); ?>",
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: itemId
                },
                success: function (response) {
                    Swal.fire(
                        'Deleted!',
                        'The billing has been deleted.',
                        'success'
                    ).then(() => {
                        location.reload();
                    });
                },
                error: function (xhr) {
                    Swal.fire(
                        'Error!',
                        'Something went wrong.',
                        'error'
                    );
                }
            });
        }
    });
});
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/quikwise-admin/resources/views/admin/billings/list.blade.php ENDPATH**/ ?>