<?php $__env->startSection('title', 'Contact Management'); ?>
<?php $__env->startSection('content'); ?>
<?php
    $authCheck = auth()->check();
    $permission= auth()->user();
 ?>
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row align-items-center">

            <div class="col-md-12">
                <div class="d-flex gap-3">
                
                    <div class="search-div">
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-magnifying-glass"></i></a></span>
                                <input type="text" class="form-control border-start-0" placeholder="Search User">
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            
            
        </div>  
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="table-responsive user-table student-table">
                    <table class="table table-striped">
                        <thead class="border-bottom">
                            <tr>
                                <th>S.No.</th>
                                <th>Full Name</th>
                                <th>Email</th>
                                <th>Subject</th>
                                <th>Actions</th> 
                            </tr>
                        </thead>
                       
                        <tbody>
                            <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($key + 1); ?></td>
                                <td><?php echo e($contact->full_name); ?></td>
                                <td><?php echo e($contact->email); ?></td>
                                <td><?php echo e($contact->subject); ?></td>
                                <?php if($authCheck && $permission->hasPermission('contacts-show')): ?>
                                    <td class="d-flex align-items-center">
                                        <a href="#" class="text-info view-details" data-id="<?php echo e($contact->id); ?>" data-bs-toggle="tooltip" data-bs-placement="top" title="View"><i class="fa-solid fa-eye"></i></a>
                                    </td>
                                <?php endif; ?>
                            </tr>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          
                        </tbody>
                    </table>
                </div>
               
            </div>
        </div>
    </div>  
</div>

<!-- Modal -->

<div class="modal fade" id="viewModal" tabindex="-1" aria-labelledby="viewModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg"> 
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="viewModalLabel">Message</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="modalContent">
        <!-- Dynamic content will be loaded here -->
        <p>Message: gjnkxfn</p>
      </div>
    </div>
  </div>
</div>



<script>
    $(document).on('click', '.view-details', function(e) {
        e.preventDefault();

        var id = $(this).data('id');
        var url= "<?php echo e(route('admin.contact.view','-id-')); ?>";
        url = url.replace('-id-',id);

        $('#modalContent').html('<p>Loading...</p>'); // Temporary
        $('#viewModal').modal('show'); // Show the modal
        // alert(url);
        // Example AJAX (optional)
        $.ajax({
            url: url,
            type: "GET",
            success: function(response) {
            
                $('#modalContent').html(response.data.message); // Replace modal content
            
            },
            error: function() {
                $('#modalContent').html('<p class="text-danger">Failed to load data.</p>');
            }
        });
    });
</script>





<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/quikwise-admin/resources/views/admin/contacts/index.blade.php ENDPATH**/ ?>