<?php $__env->startSection('title', 'Student Management'); ?>
<?php $__env->startSection('content'); ?>
 
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        

        <div class="row rounded-4 border align-items-center mx-2 mt-lg-4 mt-md-2 mt-2 px-2 py-4 view-student-details-row">  
            

            <div class="col-md-2">
                <img src="<?php echo e($student->avatar ? asset('storage/avatars/' . $student->avatar) : asset('img/no-image.png')); ?>" alt="Student Image" class="img-fluid rounded-circle">
            </div>

            <div class="col-md-5 px-0">
                <div class="table-responsive view-role-table view-student-table border-0 p-0">
                    <table class="table border-0 mb-0">
                        <tbody>
                            <tr>
                                <th class="py-1">Full Name:</th>
                                <td class="py-1"><?php echo e($student->name ?? '-'); ?></td>
                            </tr>
                            
                            <tr>
                                <th class="py-1">Email address:</th>
                                <td class="py-1">
                                    <?php echo e($student->email ?? '-'); ?>

                                    <?php if($student->is_email_verified == '1'): ?>
                                        <i class="fa-solid fa-circle-check text-success" title="Verified"></i>
                                    <?php else: ?>
                                        <i class="fa-regular fa-circle-xmark text-danger" title="Not Verified"></i> <?php echo e($student->is_email_verified); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th class="py-1">Date of Birth:</th>
                                <td class="py-1"><?php echo e(\Carbon\Carbon::parse($student->dob)->format('d/m/Y') ?? '-'); ?></td>
                            </tr>
                            
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="col-md-5 px-0">
                <div class="table-responsive view-role-table view-student-table border-0 p-0">
                    <table class="table border-0 mb-0">
                        <tbody>
                            <tr>
                                <th class="py-1">Subscription Plan:</th>
                                <td class="py-1">
                                    <?php echo e(($student->subscriptionPlan() != null && $student->subscriptionPlan()->stripe_subscription_id!='Free Trial') ?  'PAID' :'FREE'); ?>

                                </td>
                            </tr>
                            <tr>
                                <th class="py-1">Parent’s Name:</th>
                                <td class="py-1"><?php echo e($student->parent_name ?? '-'); ?></td> 
                            </tr>
                            <tr>
                                <th class="py-1">Parent’s Email ID:</th>
                                <td class="py-1"><?php echo e($student->parent_email ?? '-'); ?></i></td>
                            </tr>
                            <tr>
                                <th class="py-1">Report Frequency:</th>
                                <td class="py-1"><?php echo e($student->report_frequency ?? 'Weekly'); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/quikwise-admin/resources/views/admin/students/view.blade.php ENDPATH**/ ?>