<?php
    $authCheck = auth()->check();
    $permission= auth()->user();
 ?>  
<table class="table table-striped">
                        <thead class="border-bottom">
                            <tr>
                                <th>S.No.</th>
                                
                                <th>User Name</th>
                                <th>Email</th>
                                <th>Role</th>
                                <th>Status</th>
                                <th>Action</th>
                               
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($key + 1); ?></td>
                                
                                

                                <td>
                                    <div class="d-flex align-items-center">
                                        <img src="<?php echo e(file_exists(public_path('storage/user/' . $user->image)) && $user->image
                                            ? url('storage/user/' . $user->image)
                                            : asset('img/no-image.png')); ?>"
                                            alt="" class="rounded-circle me-2"
                                            style="width: 50px; height: 50px; object-fit: cover;">
                                        <span><?php echo e($user->name); ?></span>
                                    </div>
                                </td>
                                <td><?php echo e($user->email); ?></td>
                                <td><?php echo e($user->role()->pluck('name')->join(', ')); ?></td>

                                <td class="ms-2" id="statusLabel<?php echo e($user->id); ?>">
                                    <?php echo e($user->status == 1 ? 'Active' : 'Inactive'); ?>

                                </td>

                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="lights">
                                            <div class="form-check form-switch mb-0 h-100">
                                                <input 
                                                    class="form-check-input mt-0 change-status" 
                                                    data-bs-toggle="tooltip" data-bs-placement="top" title="Status"
                                                    type="checkbox" 
                                                    id="statusSwitch<?php echo e($user->id); ?>" 
                                                    name="statusSwitch" 
                                                    value="1"
                                                    data-id="<?php echo e(base64_encode($user->id)); ?>"
                                                    data-name="<?php echo e($user->title); ?>"
                                                    <?php echo e($user->status == 1 ? 'checked' : ''); ?>

                                                >
                                                
                                            </div>
                                        </div>
                                        <?php if($authCheck && $permission->hasPermission('user-edit')): ?>
                                        <a href="<?php echo e(route('admin.users.edit', base64_encode($user->id))); ?>" class="text-success me-2" data-bs-toggle="tooltip" data-bs-placement="top" title="Edit">
                                            <i class="fa-solid fa-pen-to-square"></i>
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          
                        </tbody>
                    </table>
                    <div class="pagination-wrapper mb-4">
                        <?php echo e($users->links()); ?>

                    </div>
<?php /**PATH /var/www/html/quikwise-admin/resources/views/admin/users/ajax.blade.php ENDPATH**/ ?>