<?php $__env->startSection('title', 'Edit Feedback Option'); ?>
<?php $__env->startSection('content'); ?>
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row mt-lg-4 mt-md-0 mt-0">
            <div class="col-md-12">
                <form id="UpdateFeedbackOption" action="<?php echo e(route('admin.feedbackoption.update')); ?>" method="POST" class="add-user-form p-4">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" value="<?php echo e(base64_encode($editfeedoption->id)); ?>">
                    <div class="row">
                        <div class="col-md-6">
                            <label for="#" class="form-label">Name<span class="text-danger">*</span></label>
                            <input type="text" class="form-control rounded-2" id="f-name" value="<?php echo e($editfeedoption->name); ?>"name="name" required>    
                            <p class="text-danger" id="error-name"></p>
                        </div>
                       
                        <div class="col-md-6 mt-lg-0 mt-md-0 mt-4">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control rounded-2 form-select" name="status" id="status">
                                <option value="1" <?php echo e($editfeedoption->status == 1 ? 'selected' : ''); ?>>Active</option>
                                <option value="0" <?php echo e($editfeedoption->status == 0 ? 'selected' : ''); ?>>Inactive</option>
                            </select>
                             <p class="text-danger" id="error-status"></p>
                        </div>
                   
                    </div>
                   
                    <div class="row mt-5">
                        <div class="col-md-6">
                        <button type="submit" class="btn add-btn px-4 py-3 w-100 rounded-pill">Update</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).on('submit', 'form#UpdateFeedbackOption', function(e) {
        e.preventDefault();

        var form = $(this);
        var formData = new FormData(this);

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message || "Updated Successfully");

                    window.setTimeout(function() {
                        window.location.href = "<?php echo e(route('admin.feedback-option')); ?>";
                    }, 2000);
                } else if (response.errors) {

                    $.each(response.errors, function(key, error) {
                        var errorId = `#error-${key.replace('.', '_')}`;
                        $(errorId).html(error[0]);
                    });
                } else {
                    alert("No changes were made.");
                }
            },
            error: function(xhr) {
                alert("An error occurred. Please try again.");
                console.log(xhr.responseText);
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/quikwise-admin/resources/views/admin/feedback-option/edit.blade.php ENDPATH**/ ?>