<?php $__env->startSection('title', 'Edit Role'); ?>
<?php $__env->startSection('content'); ?>
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="card border-0 rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row mt-lg-4 mt-md-0 mt-0">
            <div class="col-md-12">
                                
                <form id="updaterole" class="add-user-form p-4">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                   
                    <div class="row">
                        <div class="col-md-6">
                            <label for="#" class="form-label">Role Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control rounded-2" value="<?php echo e($role->name); ?>" name="name">    
                        </div>
                        <p class="text-danger" id="error-name"></p>
                    </div>

                     <div class="row mt-4">
                        <div class="col-md-6">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="rounded-2 d-block p-2" name="description" rows="5" placeholder="Enter description"><?php echo e($role->description); ?></textarea>
                            
                        </div>
                    </div>

                    <div class="row mt-5">
                        <div class="col-md-6">
                            <button type="submit" class="btn add-btn px-4 py-3 w-100 rounded-pill">Update Role</button>
                            
                            
                        </div>
                    </div>
                </form>
               
            </div>
        </div>
    </div>
    <div class="card rounded-2 border-0 bg-white py-4 px-5 mt-4">
        <h5 class="mb-3">Assign Permissions</h5>
       
        <form id="updatepermission" class="add-user-form p-4">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="row">
                <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="permission_<?php echo e($permission->id); ?>" name="permissions[]" 
                                value="<?php echo e($permission->id); ?>" 
                                <?php echo e(in_array($permission->id, $role->permission_ids) ? 'checked' : ''); ?>

                                >
                            <label class="form-check-label" for="permission_<?php echo e($permission->id); ?>"><?php echo e($permission->name); ?><br><sup><?php echo e($permission->slug); ?></sup></label>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <button type="submit" class="btn permission-add-btn add-btn px-4 py-3 w-50 mt-4 rounded-pill">Update Permissions</button>
        </form>
    </div>
</div>
<!-- <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-2Xc9E9Y1K+5yBUwY3a4RTkKT07Mx/xZ2SJ1dF3A0p3g="
        crossorigin="anonymous"></script> -->
<script>
// $('#updaterole').on('submit', function(e) {
//     e.preventDefault();

//     $('#submitBtn').attr('disabled', true);
//     $('small').text('');
//     $('#successMessage').text('');

//     $.ajax({
//         url: '<?php echo e(route('admin.roles.update', $role->id)); ?>',
//         method: 'POST',
//         data: $(this).serialize(),
//         success: function(response) {
//             $('#submitBtn').attr('disabled', false);
//             showAlert(response.message,'s');
//         },
//         error: function(xhr) {
//             $('#submitBtn').attr('disabled', false);
            
//             if(xhr.status == 422) {
//                 let errors = xhr.responseJSON.errors;
//                 $.each(errors, function(key, value) {
//                     $('#' + key + '_error').text(value[0]);
//                 });
//             }
//         }
//     });
// });

    $(document).on('submit', 'form#updaterole', function(e) {
        e.preventDefault();
        var form = $(this);
        var formData = new FormData(this);

        $.ajax({
            url: '<?php echo e(route('admin.roles.update', $role->id)); ?>',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                console.log(response);
                if (response.success) {
                    toastr.success(response.message || "Updated Successfully");

                    window.setTimeout(function() {
                        window.location.href = "<?php echo e(route('admin.roles.index')); ?>";
                    }, 2000);
                } else if (response.errors) {

                    $.each(response.errors, function(key, error) {
                        var errorId = `#error-${key.replace('.', '_')}`;
                        $(errorId).html(error[0]);
                    });
                } else {
                    alert("No changes were made.");
                }
            },
            error: function(xhr) {
                alert("An error occurred. Please try again.");
                console.log(xhr.responseText);
            }
        });
    });
       
</script>


<script>
$('#updatepermission').on('submit', function(e) {
    e.preventDefault();

    $('#submitBtn').attr('disabled', true);
    $('small').text('');
    $('#successMessage').text('');

    $.ajax({
        url: '<?php echo e(route('admin.roles.updatePermissions', $role->id)); ?>',
        method: 'POST',
        data: $(this).serialize(),
        success: function(response) {
            $('#submitBtn').attr('disabled', false);
            showAlert(response.message,'s');
        },
        error: function(xhr) {
            $('#submitBtn').attr('disabled', false);
            
            if(xhr.status == 422) {
                let errors = xhr.responseJSON.errors;
                $.each(errors, function(key, value) {
                    $('#' + key + '_error').text(value[0]);
                    toastr.warning(value[0]);
                });
            }
        }
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/quikwise-admin/resources/views/admin/roles/edit.blade.php ENDPATH**/ ?>