<?php $__env->startSection('title', 'Revenue Master'); ?>
<?php $__env->startSection('content'); ?>

 
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="row align-items-center">
                    <div class="col-lg-4 col-md-4 col-6">
                        <div class="revenue-div p-4 border">
                            <h4>$<?php echo e($totalAmount); ?> USD</h4>
                            <p class="mb-0">Total Revenue</p>
                        </div>
                    </div>
                    <div class="col-lg-8 col-md-8 col-6">
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-magnifying-glass"></i></a></span>
                                <input type="text" id="searchData" class="form-control border-start-0" placeholder="Search User">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
        </div>  
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="table-responsive user-table user-table-main revenue-table-responsive" id="data-list">
                    <?php echo $__env->make('admin.revenue.list', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <!-- Loading Spinner -->
                    <div id="loading" class="position-absolute top-50 start-50" style="display:none;">
                        <div class="loader"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>  
</div>


<script>
    $(document).ready(function() {

        function fetchData(url){
            let search = $('#searchData').val();

            $.ajax({
                url: url,
                type: "GET",
                data: { search: search },
                beforeSend: function() {
                    $('#loading').show();
                },
                success: function(data){
                    $('#data-list').html(data);
                    $('#loading').hide();
                },
                error: function() {
                    alert('Error loading data.');
                    $('#loading').hide();
                }
            });
        }

        // Handle Pagination Click
        $(document).on('click', '.pagination-wrapper a', function(e) {
            e.preventDefault();
            let url = $(this).attr('href');
            fetchData(url);
        });

        // Handle Search Input Typing (with delay)
        let typingTimer;
        let doneTypingInterval = 500; // 0.5 second after user stops typing

        $('#searchData').on('keyup', function () {
            clearTimeout(typingTimer);
            typingTimer = setTimeout(function() {
                fetchData("<?php echo e(route('admin.revenue.index')); ?>");
            }, doneTypingInterval);
        });

        $('#searchData').on('keydown', function () {
            clearTimeout(typingTimer);
        });

    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/quikwise-admin/resources/views/admin/revenue/index.blade.php ENDPATH**/ ?>