<header>
    <nav class="navbar navbar-expand-sm navbar-white bg-white header-navbar py-2 px-4 position-fixed">
        <div class="container-fluid">
            <h3 class="mb-0 header-heading"><?php echo $__env->yieldContent('title', 'Admin Panel'); ?></h3> 
            <a href="#" class="d-lg-none d-md-block d-block text-decoration-none text-dark" onclick="w3_open()"><i class="fa-solid fa-circle-chevron-right"></i></a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mynavbar">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-end" id="mynavbar">
                <ul class="navbar-nav align-items-lg-center align-items-md-center align-items-start">
                    <li class="nav-item me-2">
                        <a class="nav-link bell-link" href="javascript:void(0)"><img src="<?php echo e(asset('img/bell.svg')); ?>" alt=""></a>
                    </li>
                    <?php
                        $admin = Auth::guard('admin')->user();
                    ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" data-bs-toggle="dropdown" href="javascript:void(0)"><img src="<?php echo e(asset('img/Mask Group.png')); ?>" class="me-2"><?php echo e($admin->name); ?></a>
                        <ul class="dropdown-menu p-4 profile-menu border-0 shadow">
                            <div class="border-bottom">
                                <div class="dd-profile-img">
                                    <img src="<?php echo e(asset('img/dd-profile-img.png')); ?>" class="rounded-circle">
                                </div>
                               
                                <div class="dd-profile-text mt-3">
                                    <h4 class="profile-heading"><?php echo e($admin->name); ?></h4>
                                    <p class="mb-2 profile-text"><?php echo e($admin->email); ?></p>
                                </div>
                            </div>
                            <li><a class="dropdown-item px-0 d-flex align-items-center gap-2 py-2" href="<?php echo e(route('admin.myprofile')); ?>"><img src="img/profile-setting-icon.png" alt=""> Profile Settings</a></li>
                            
                             <form method="POST" action="<?php echo e(route('admin.logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <li><a class="dropdown-item px-0 d-flex align-items-center gap-2 py-2" href="<?php echo e(route('admin.logout')); ?>" onclick="event.preventDefault(); this.closest('form').submit();"data-bs-toggle="modal" data-bs-target="#myModal3"><img src="img/logout-icon.png" alt=""> Logout</a></li>
                             </form>
                        </ul>
                    </li>
                </ul>
            </div>
            
        </div>
    </nav>
</header><?php /**PATH /var/www/html/quikwise-admin/resources/views/layouts/admin/header.blade.php ENDPATH**/ ?>