

    <?php
    $authCheck = auth()->check();
    $permission= auth()->user();
    ?>
    <div class="sidebar h-100 position-fixed w3-sidebar w3-bar-block w3-collapse w3-card w3-animate-left" id="mySidebar">
        <div class="sidebar-logo p-4 text-start border-bottom border-white d-flex justify-content-between">
            <img src="<?php echo e(asset('img/Logo3.png')); ?>" alt="">
            <a href="#" class="d-lg-none d-md-block d-block text-decoration-none text-white" onclick="w3_close()"><i class="fa-solid fa-circle-xmark"></i></a>
        </div>
        <div class="sidebar-module py-4">
            <nav class="navbar bg-transparent sidebar-navbar">
                <div class="container-fluid justify-content-center">
                    <ul class="navbar-nav w-100 px-2">
                        <li class="nav-item my-1">
                            <a class="nav-link d-flex align-items-center <?php echo e(Request::segment(2) == 'dashboard' ? 'active' : ''); ?> gap-2" href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa-solid fa-gauge"></i> Dashboard</a>
                        </li>

                        

                        <li class="nav-item my-1">
                            <a class="nav-link d-flex align-items-center gap-2 <?php echo e(Request::segment(2) == 'users' || Request::segment(2) == 'roles' ? '' : 'collapsed'); ?>" data-bs-toggle="collapse" href="#usersSubmenu" role="button" aria-expanded="<?php echo e(Request::segment(2) == 'users' || Request::segment(2) == 'roles' ? 'true' : 'false'); ?>" aria-controls="usersSubmenu">
                                <i class="fa-solid fa-user"></i> User Management
                                <i class="fa-solid fa-chevron-down ms-auto"></i>
                            </a>
                            <div class="collapse <?php echo e(Request::segment(2) == 'users' || Request::segment(2) == 'roles' ? 'show' : ''); ?>" id="usersSubmenu">
                                <ul class="btn-toggle-nav list-unstyled fw-normal pb-1 small ms-4">
                                
                                    <?php if($authCheck && $permission->hasPermission('user-show')): ?>
                                        <li class="my-1">
                                            <a href="<?php echo e(route('admin.users.index')); ?>" class="nav-link <?php echo e(Request::routeIs('admin.users.index') ? 'active' : ''); ?>">User</a>
                                        </li>
                                    <?php endif; ?>
                                    
                                        <li class="my-1">
                                            <a href="<?php echo e(route('admin.roles.index')); ?>" class="nav-link <?php echo e(Request::routeIs('admin.roles.index') ? 'active' : ''); ?>"> <i class="fa-solid fa-user-gear"></i>Manage Role</a>
                                        </li>
                                    
                                </ul>
                            </div>
                        </li>
                        
                        

                        <li class="nav-item my-1">
                            
                        </li>


                        
                        

                        <?php if($authCheck && $permission->hasPermission('student-show')): ?>
                            <li class="nav-item my-1">
                                <a class="nav-link d-flex align-items-center <?php echo e(Request::segment(2) == 'student' ? 'active' : ''); ?> gap-2" href="<?php echo e(route('admin.student')); ?>"><i class="fa-solid fa-user-tie"></i>Students</a>
                            </li>
                        <?php endif; ?> 

                        <li class="nav-item my-1">
                            <a class="nav-link d-flex align-items-center gap-2 <?php echo e(Request::segment(2) == 'revenue' || Request::segment(2) == 'revenue' ? '' : 'collapsed'); ?>" data-bs-toggle="collapse" href="#reveSubmenu" role="button" aria-expanded="<?php echo e(Request::segment(2) == 'revenue' || Request::segment(2) == 'billing' ? 'true' : 'false'); ?>" aria-controls="reveSubmenu">
                                <i class="fa-solid fa-user"></i> Revenue 
                                <i class="fa-solid fa-chevron-down ms-auto"></i>
                            </a>
                            <div class="collapse <?php echo e(Request::segment(2) == 'revenue' || Request::segment(2) == 'billing' ? 'show' : ''); ?>" id="reveSubmenu">
                                <ul class="btn-toggle-nav list-unstyled fw-normal pb-1 small ms-4">
                                    <?php if($authCheck && $permission->hasPermission('revenue-show')): ?>
                                        <li class="my-1">
                                            <a href="<?php echo e(route('admin.revenue.index')); ?>" class="nav-link <?php echo e(Request::routeIs('admin.revenue.index') ? 'active' : ''); ?>"></i>Revenue Management</a>
                                        </li>
                                    <?php endif; ?> 
                                    <?php if($authCheck && $permission->hasPermission('billing-show')): ?>
                                        <li class="my-1">
                                            <a href="<?php echo e(route('admin.billing')); ?>" class="nav-link <?php echo e(Request::routeIs('admin.billing') ? 'active' : ''); ?>">Billing & Subscription</a>
                                        </li>
                                    <?php endif; ?> 
                                </ul>
                            </div>
                        </li>  
                        

                        <li class="nav-item my-1">
                            <a class="nav-link d-flex align-items-center gap-2 <?php echo e(Request::segment(2) == 'feedback' || Request::segment(2) == 'feedback' ? '' : 'collapsed'); ?>" data-bs-toggle="collapse" href="#feedbackSubmenu" role="button" aria-expanded="<?php echo e(Request::segment(2) == 'feedback' || Request::segment(2) == 'feedback-option' ? 'true' : 'false'); ?>" aria-controls="feedbackSubmenu">
                                <i class="fa-solid fa-user"></i> Feedback 
                                <i class="fa-solid fa-chevron-down ms-auto"></i>
                            </a>
                            <div class="collapse <?php echo e(Request::segment(2) == 'feedback' || Request::segment(2) == 'feedback-option' ? 'show' : ''); ?>" id="feedbackSubmenu">
                                <ul class="btn-toggle-nav list-unstyled fw-normal pb-1 small ms-4">
                                        <?php if($authCheck && $permission->hasPermission('feedback-show')): ?>
                                        <li class="my-1">
                                            <a href="<?php echo e(route('admin.feedback')); ?>" class="nav-link <?php echo e(Request::routeIs('admin.feedback') ? 'active' : ''); ?>"></i>User Feedback</a>
                                        </li>
                                        <?php endif; ?>
                                         <?php if($authCheck && $permission->hasPermission('feedbackoption-show')): ?>
                                        <li class="my-1">
                                            <a href="<?php echo e(route('admin.feedback-option')); ?>" class="nav-link <?php echo e(Request::routeIs('admin.feedback-option') ? 'active' : ''); ?>">Feedback Option</a>
                                        </li>
                                        <?php endif; ?>
                                    
                                </ul>
                            </div>
                        </li>  


                        
                        
                        

                        
                        
                        <?php if($authCheck && $permission->hasPermission('contacts-show')): ?>
                         <li class="nav-item my-1">
                            <a class="nav-link d-flex align-items-center <?php echo e(Request::segment(2) == 'contacts' ? 'active' : ''); ?> gap-2" href="<?php echo e(route('admin.contacts')); ?>"><i class="fa-solid fa-address-card"></i> Contacts</a>
                        </li>
                        <?php endif; ?>
                        <li class="nav-item my-1">
                            <a class="nav-link d-flex align-items-center gap-2 <?php echo e(Request::segment(2) == 'faqs' || Request::segment(2) == 'faqs' ? '' : 'collapsed'); ?>" data-bs-toggle="collapse" href="#faqSubmenu" role="button" aria-expanded="<?php echo e(Request::segment(2) == 'faqs' || Request::segment(2) == 'faq-category' ? 'true' : 'false'); ?>" aria-controls="faqSubmenu">
                                <i class="fa-solid fa-user"></i> FAQ
                                <i class="fa-solid fa-chevron-down ms-auto"></i>
                            </a>
                            <div class="collapse <?php echo e(Request::segment(2) == 'faqs' || Request::segment(2) == 'faq-category' ? 'show' : ''); ?>" id="faqSubmenu">
                                <ul class="btn-toggle-nav list-unstyled fw-normal pb-1 small ms-4">
                                        <?php if($authCheck && $permission->hasPermission('faqcategory-show')): ?>
                                        <li class="my-1">
                                            <a href="<?php echo e(route('admin.faq-category')); ?>" class="nav-link <?php echo e(Request::routeIs('admin.faq-category') ? 'active' : ''); ?>"></i>Category</a>
                                        </li>
                                        <?php endif; ?>
                                        
                                            <li class="my-1">
                                                <a href="<?php echo e(route('admin.faqs.index')); ?>" class="nav-link <?php echo e(Request::routeIs('admin.faqs.index') ? 'active' : ''); ?>">FAQ Listing</a>
                                            </li>
                                        
                                </ul>
                            </div>
                        </li>  

                        
                        


                        
                        

                        
                        <li class="nav-item my-1">
                            <a class="nav-link d-flex align-items-center <?php echo e(Request::segment(2) == 'subjects' ? 'active' : ''); ?> gap-2" href="<?php echo e(route('admin.subjects')); ?>"><i class="fa-solid fa-user-pen"></i> Subjects</a>
                        </li>
                        


                         <li class="nav-item my-1">
                            <a class="nav-link d-flex align-items-center <?php echo e(Request::segment(2) == 'sample-questions' ? 'active' : ''); ?> gap-2" href="<?php echo e(route('admin.sample-questions')); ?>"><i class="fa-solid fa-file-pen"></i> Sample Questions</a>
                        </li>
                        
                       

                        
                        
                        
                        
                        
                        
                    </ul>
                </div>
            </nav>
            
        </div>
    </div>
    <script>
        function w3_open() {
          document.getElementById("mySidebar").style.left = "0px";
        }
        
        function w3_close() {
          document.getElementById("mySidebar").style.left    = "-300px";
        }
    </script>

<?php /**PATH /var/www/html/quikwise-admin/resources/views/layouts/admin/sidebar.blade.php ENDPATH**/ ?>