<?php $__env->startSection('title', 'Feedback Option Management'); ?>
<?php $__env->startSection('content'); ?>
<?php
    $authCheck = auth()->check();
    $permission= auth()->user();
 ?>
<div class="dashboard-content bg-light p-4 mt-5">
    <div class="content-card rounded-2 bg-white p-4 mt-lg-4 mt-md-4 mt-1">
        <div class="row align-items-lg-center align-items-md-start align-items-center">

            <div class="col-md-12">
                <div class="d-flex justify-content-between">
                 <?php if($authCheck && $permission->hasPermission('feedbackoption-create')): ?>
                <div class="add-div-btn">
                    <a href="<?php echo e(route('admin.feedback-option.create')); ?>" class="btn add-btn px-4 py-2">Add Feedback Option</a>
                </div>
                <?php endif; ?>
                    <div class="add-div-btn">
                        <form>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><a href="#" class="text-dark"><i class="fa-solid fa-magnifying-glass"></i></a></span>
                                <input type="text" class="form-control border-start-0" placeholder="Search User" id="searchData">
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            
        </div>  
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="table-responsive user-table student-table" id="data-list">
                    <?php echo $__env->make('admin.feedback-option.ajax', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    
                </div>
               
            </div>
        </div>
    </div>  
</div>


<script>
    $(document).on('change', '.change-status', function () {
        const checkbox = $(this);
        const id = checkbox.data('id');
        const name = checkbox.data('name');
        const isChecked = checkbox.is(':checked');
        const type = isChecked ? btoa('enable') : btoa('disable');
        const action = isChecked ? 'activate' : 'deactivate';

        Swal.fire({
            icon: 'warning',
            title: `Are you sure you want to ${action} "${name}"?`,
            showCancelButton: true,
            confirmButtonColor: '#007358',
            confirmButtonText: 'YES',
            cancelButtonText: 'CANCEL'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: "<?php echo e(route('admin.feedbackoption-status')); ?>",
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        'id': id,
                        'type': type
                    },
                    success: function (response) {
                        if (response.success) {
                            $(`#statusLabel${atob(id)}`).text(isChecked ? 'Active' : 'Inactive');
                            toastr.success("Status Changed Successfully");
                        } else {
                            toastr.error("Failed to change status");
                            checkbox.prop('checked', !isChecked); // Revert switch
                        }
                    },
                    error: function (xhr, textStatus, errorThrown) {
                        toastr.error("An error occurred: " + errorThrown);
                        checkbox.prop('checked', !isChecked); // Revert switch
                    }
                });
            } else {
                checkbox.prop('checked', !isChecked); // Revert if cancelled
            }
        });
    });
</script>



<script>
    $(document).on('click', '.delete-btn', function () {
        var itemId = $(this).data('id');

        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "<?php echo e(route('admin.feedbackoption.delete')); ?>",
                    type: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        id: itemId
                    },
                    success: function (response) {
                        Swal.fire(
                            'Deleted!',
                            'The feedback option has been deleted.',
                            'success'
                        ).then(() => {
                            location.reload();
                        });
                    },
                    error: function (xhr) {
                        Swal.fire(
                            'Error!',
                            'Something went wrong.',
                            'error'
                        );
                    }
                });
            }
        });
    });
</script>


<script>
    $(document).ready(function() {

        function fetchData(url){
            let search = $('#searchData').val();

            $.ajax({
                url: url,
                type: "GET",
                data: { search: search },
                beforeSend: function() {
                    $('#loading').show();
                },
                success: function(data){
                    $('#data-list').html(data);
                    $('#loading').hide();
                },
                error: function() {
                    alert('Error loading data.');
                    $('#loading').hide();
                }
            });
        }

        // Handle Pagination Click
        $(document).on('click', '.pagination-wrapper a', function(e) {
            e.preventDefault();
            let url = $(this).attr('href');
            fetchData(url);
        });

        // Handle Search Input Typing (with delay)
        let typingTimer;
        let doneTypingInterval = 500; // 0.5 second after user stops typing

        $('#searchData').on('keyup', function () {
            clearTimeout(typingTimer);
            typingTimer = setTimeout(function() {
                fetchData(window.location.href);
            }, doneTypingInterval);
        });

        $('#searchData').on('keydown', function () {
            clearTimeout(typingTimer);
        });

    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/quikwise-admin/resources/views/admin/feedback-option/index.blade.php ENDPATH**/ ?>